import QtQuick 2.15
import QtQuick.Controls 2.15

Row {
    id: _root
    height: 28

    property string title: ""
    property string comment : ""
    property alias text: inputItem.text
    property alias enabled: inputItem.enabled

    signal editingFinished()

    Text {
        width: 100
        height: parent.height
        font.pointSize: 14
        text: parent.title
        verticalAlignment: Text.AlignVCenter
    }
    Rectangle {
        width: inputItem.contentWidth < 148+48 ? 148+48 : inputItem.contentWidth + 10
        height: 24
        color: "white"
        border.color: "grey"
        TextInput {
            id: inputItem
            anchors.fill: parent
            anchors.margins: 2
            font.pointSize: 15
            horizontalAlignment: Text.AlignHCenter
            clip: true
            onEditingFinished: {
                _root.editingFinished()
            }
        }
    }
    Text {
        width: contentWidth
        height: parent.height
        font.pointSize: 14
        text: parent.comment
        verticalAlignment: Text.AlignVCenter
    }
}
